package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseParametersResponse(
    parameters: Option[Iterable[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter
    ]] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse = {
    import GetRelationalDatabaseParametersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse
      .builder()
      .optionallyWith(
        parameters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.parameters)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseParametersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseParametersResponse(
          parametersValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value)
        )
    def parametersValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly
    ]]
    def nextPageTokenValue: Option[String]
    def parameters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly
    ]] = AwsError.unwrapOptionField("parameters", parametersValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly {
    override def parametersValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter.ReadOnly
    ]] = scala
      .Option(impl.parameters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseParameter
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseParametersResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseParametersResponse.ReadOnly =
    new Wrapper(impl)
}
