package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseMasterUserPasswordRequest(
    relationalDatabaseName: ResourceName,
    passwordVersion: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabasePasswordVersion
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest = {
    import GetRelationalDatabaseMasterUserPasswordRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
      .builder()
      .relationalDatabaseName(relationalDatabaseName: java.lang.String)
      .optionallyWith(passwordVersion.map(value => value.unwrap))(
        _.passwordVersion
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseMasterUserPasswordRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseMasterUserPasswordRequest(
          relationalDatabaseNameValue,
          passwordVersionValue.map(value => value)
        )
    def relationalDatabaseNameValue: ResourceName
    def passwordVersionValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabasePasswordVersion
    ]
    def relationalDatabaseName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(relationalDatabaseNameValue)
    def passwordVersion: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabasePasswordVersion
    ] = AwsError.unwrapOptionField("passwordVersion", passwordVersionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest.ReadOnly {
    override def relationalDatabaseNameValue: ResourceName =
      impl.relationalDatabaseName(): ResourceName
    override def passwordVersionValue: Option[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabasePasswordVersion
    ] = scala
      .Option(impl.passwordVersion())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.RelationalDatabasePasswordVersion
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseMasterUserPasswordRequest.ReadOnly =
    new Wrapper(impl)
}
