package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetRelationalDatabaseBundlesResponse(
    bundles: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle]
    ] = None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse = {
    import GetRelationalDatabaseBundlesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse
      .builder()
      .optionallyWith(
        bundles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.bundles)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse
      .wrap(buildAwsValue())
}
object GetRelationalDatabaseBundlesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetRelationalDatabaseBundlesResponse(
          bundlesValue.map(value =>
            value.map { item =>
              item.editable
            }
          ),
          nextPageTokenValue.map(value => value)
        )
    def bundlesValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle.ReadOnly
    ]]
    def nextPageTokenValue: Option[String]
    def bundles: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle.ReadOnly
    ]] = AwsError.unwrapOptionField("bundles", bundlesValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly {
    override def bundlesValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle.ReadOnly
    ]] = scala
      .Option(impl.bundles())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.RelationalDatabaseBundle
            .wrap(item)
        }.toList
      )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetRelationalDatabaseBundlesResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetRelationalDatabaseBundlesResponse.ReadOnly =
    new Wrapper(impl)
}
