package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetOperationsForResourceRequest(
    resourceName: ResourceName,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest = {
    import GetOperationsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceRequest
      .wrap(buildAwsValue())
}
object GetOperationsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceRequest =
      io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceRequest(
        resourceNameValue,
        pageTokenValue.map(value => value)
      )
    def resourceNameValue: ResourceName
    def pageTokenValue: Option[String]
    def resourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceNameValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceRequest.ReadOnly {
    override def resourceNameValue: ResourceName =
      impl.resourceName(): ResourceName
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetOperationsForResourceRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetOperationsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
