package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetKeyPairResponse(
    keyPair: Option[io.github.vigoo.zioaws.lightsail.model.KeyPair] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse = {
    import GetKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse
      .builder()
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse
      .wrap(buildAwsValue())
}
object GetKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetKeyPairResponse(keyPairValue.map(value => value.editable))
    def keyPairValue
        : Option[io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly]
    def keyPair: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly
    ] = AwsError.unwrapOptionField("keyPair", keyPairValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.ReadOnly {
    override def keyPairValue
        : Option[io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly] =
      scala
        .Option(impl.keyPair())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.KeyPair.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetKeyPairResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetKeyPairResponse.ReadOnly =
    new Wrapper(impl)
}
