package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetInstanceSnapshotsRequest(pageToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest = {
    import GetInstanceSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsRequest
      .wrap(buildAwsValue())
}
object GetInstanceSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetInstanceSnapshotsRequest(pageTokenValue.map(value => value))
    def pageTokenValue: Option[String]
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsRequest.ReadOnly {
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetInstanceSnapshotsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetInstanceSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
