package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.DomainName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDomainRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDomainRequest = {
    import GetDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDomainRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDomainRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDomainRequest
      .wrap(buildAwsValue())
}
object GetDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetDomainRequest =
      io.github.vigoo.zioaws.lightsail.model.GetDomainRequest(domainNameValue)
    def domainNameValue: DomainName
    def domainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDomainRequest.ReadOnly {
    override def domainNameValue: DomainName = impl.domainName(): DomainName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDomainRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetDomainRequest.ReadOnly =
    new Wrapper(impl)
}
