package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDistributionLatestCacheResetRequest(
    distributionName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest = {
    import GetDistributionLatestCacheResetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest
      .builder()
      .optionallyWith(distributionName.map(value => value: java.lang.String))(
        _.distributionName
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetRequest
      .wrap(buildAwsValue())
}
object GetDistributionLatestCacheResetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetDistributionLatestCacheResetRequest(
          distributionNameValue.map(value => value)
        )
    def distributionNameValue: Option[ResourceName]
    def distributionName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("distributionName", distributionNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetRequest.ReadOnly {
    override def distributionNameValue: Option[ResourceName] =
      scala.Option(impl.distributionName()).map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDistributionLatestCacheResetRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetDistributionLatestCacheResetRequest.ReadOnly =
    new Wrapper(impl)
}
