package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDiskSnapshotsRequest(pageToken: Option[String] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest = {
    import GetDiskSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest
      .builder()
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsRequest
      .wrap(buildAwsValue())
}
object GetDiskSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetDiskSnapshotsRequest(pageTokenValue.map(value => value))
    def pageTokenValue: Option[String]
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsRequest.ReadOnly {
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskSnapshotsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetDiskSnapshotsRequest.ReadOnly =
    new Wrapper(impl)
}
