package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.core.BuilderHelper
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  MetricPeriod,
  IsoDate,
  ContainerServiceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetContainerServiceMetricDataRequest(
    serviceName: ContainerServiceName,
    metricName: io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName,
    startTime: IsoDate,
    endTime: IsoDate,
    period: MetricPeriod,
    statistics: Iterable[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest = {
    import GetContainerServiceMetricDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .metricName(metricName.unwrap)
      .startTime(startTime: Instant)
      .endTime(endTime: Instant)
      .period(period: Integer)
      .statisticsWithStrings(statistics.map { item =>
        item.unwrap.toString
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataRequest
      .wrap(buildAwsValue())
}
object GetContainerServiceMetricDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetContainerServiceMetricDataRequest(
          serviceNameValue,
          metricNameValue,
          startTimeValue,
          endTimeValue,
          periodValue,
          statisticsValue
        )
    def serviceNameValue: ContainerServiceName
    def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName
    def startTimeValue: IsoDate
    def endTimeValue: IsoDate
    def periodValue: MetricPeriod
    def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic]
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
    def metricName: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName
    ] = ZIO.succeed(metricNameValue)
    def startTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(startTimeValue)
    def endTime: ZIO[Any, Nothing, IsoDate] = ZIO.succeed(endTimeValue)
    def period: ZIO[Any, Nothing, MetricPeriod] = ZIO.succeed(periodValue)
    def statistics: ZIO[Any, Nothing, List[
      io.github.vigoo.zioaws.lightsail.model.MetricStatistic
    ]] = ZIO.succeed(statisticsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
    override def metricNameValue
        : io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName =
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName
        .wrap(impl.metricName())
    override def startTimeValue: IsoDate = impl.startTime(): IsoDate
    override def endTimeValue: IsoDate = impl.endTime(): IsoDate
    override def periodValue: MetricPeriod = impl.period(): MetricPeriod
    override def statisticsValue
        : List[io.github.vigoo.zioaws.lightsail.model.MetricStatistic] = impl
      .statistics()
      .asScala
      .map { item =>
        io.github.vigoo.zioaws.lightsail.model.MetricStatistic.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataRequest.ReadOnly =
    new Wrapper(impl)
}
