package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerServiceDeploymentsResponse(
    deployments: Option[Iterable[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse = {
    import GetContainerServiceDeploymentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse
      .builder()
      .optionallyWith(
        deployments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.deployments)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse
      .wrap(buildAwsValue())
}
object GetContainerServiceDeploymentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetContainerServiceDeploymentsResponse(
          deploymentsValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def deploymentsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ]]
    def deployments: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ]] = AwsError.unwrapOptionField("deployments", deploymentsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly {
    override def deploymentsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ]] = scala
      .Option(impl.deployments())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceDeploymentsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerServiceDeploymentsResponse.ReadOnly =
    new Wrapper(impl)
}
