package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  IsoDate,
  ContainerServiceName
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerLogRequest(
    serviceName: ContainerServiceName,
    containerName: String,
    startTime: Option[IsoDate] = None,
    endTime: Option[IsoDate] = None,
    filterPattern: Option[String] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest = {
    import GetContainerLogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .containerName(containerName: java.lang.String)
      .optionallyWith(startTime.map(value => value: Instant))(_.startTime)
      .optionallyWith(endTime.map(value => value: Instant))(_.endTime)
      .optionallyWith(filterPattern.map(value => value: java.lang.String))(
        _.filterPattern
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerLogRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerLogRequest
      .wrap(buildAwsValue())
}
object GetContainerLogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerLogRequest =
      io.github.vigoo.zioaws.lightsail.model.GetContainerLogRequest(
        serviceNameValue,
        containerNameValue,
        startTimeValue.map(value => value),
        endTimeValue.map(value => value),
        filterPatternValue.map(value => value),
        pageTokenValue.map(value => value)
      )
    def serviceNameValue: ContainerServiceName
    def containerNameValue: String
    def startTimeValue: Option[IsoDate]
    def endTimeValue: Option[IsoDate]
    def filterPatternValue: Option[String]
    def pageTokenValue: Option[String]
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
    def containerName: ZIO[Any, Nothing, String] =
      ZIO.succeed(containerNameValue)
    def startTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("startTime", startTimeValue)
    def endTime: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("endTime", endTimeValue)
    def filterPattern: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("filterPattern", filterPatternValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerLogRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
    override def containerNameValue: String = impl.containerName(): String
    override def startTimeValue: Option[IsoDate] =
      scala.Option(impl.startTime()).map(value => value: IsoDate)
    override def endTimeValue: Option[IsoDate] =
      scala.Option(impl.endTime()).map(value => value: IsoDate)
    override def filterPatternValue: Option[String] =
      scala.Option(impl.filterPattern()).map(value => value: String)
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerLogRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerLogRequest.ReadOnly =
    new Wrapper(impl)
}
