package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketsResponse(
    buckets: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Bucket]] =
      None,
    nextPageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketsResponse = {
    import GetBucketsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
      .builder()
      .optionallyWith(
        buckets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.buckets)
      .optionallyWith(nextPageToken.map(value => value: java.lang.String))(
        _.nextPageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse
      .wrap(buildAwsValue())
}
object GetBucketsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse =
      io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse(
        bucketsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextPageTokenValue.map(value => value)
      )
    def bucketsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly]]
    def nextPageTokenValue: Option[String]
    def buckets: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly
    ]] = AwsError.unwrapOptionField("buckets", bucketsValue)
    def nextPageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextPageToken", nextPageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.ReadOnly {
    override def bucketsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Bucket.ReadOnly]] =
      scala
        .Option(impl.buckets())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Bucket.wrap(item)
          }.toList
        )
    override def nextPageTokenValue: Option[String] =
      scala.Option(impl.nextPageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketsResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetBucketsResponse.ReadOnly =
    new Wrapper(impl)
}
