package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBucketAccessKeysResponse(
    accessKeys: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AccessKey]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse = {
    import GetBucketAccessKeysResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse
      .builder()
      .optionallyWith(
        accessKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessKeys)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse
      .wrap(buildAwsValue())
}
object GetBucketAccessKeysResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse =
      io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse(
        accessKeysValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def accessKeysValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly]
    ]
    def accessKeys: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly
    ]] = AwsError.unwrapOptionField("accessKeys", accessKeysValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly {
    override def accessKeysValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AccessKey.ReadOnly]
    ] = scala
      .Option(impl.accessKeys())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AccessKey.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBucketAccessKeysResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetBucketAccessKeysResponse.ReadOnly =
    new Wrapper(impl)
}
