package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetBlueprintsRequest(
    includeInactive: Option[Boolean] = None,
    pageToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest = {
    import GetBlueprintsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest
      .builder()
      .optionallyWith(includeInactive.map(value => value: java.lang.Boolean))(
        _.includeInactive
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetBlueprintsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetBlueprintsRequest
      .wrap(buildAwsValue())
}
object GetBlueprintsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetBlueprintsRequest =
      io.github.vigoo.zioaws.lightsail.model.GetBlueprintsRequest(
        includeInactiveValue.map(value => value),
        pageTokenValue.map(value => value)
      )
    def includeInactiveValue: Option[Boolean]
    def pageTokenValue: Option[String]
    def includeInactive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("includeInactive", includeInactiveValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetBlueprintsRequest.ReadOnly {
    override def includeInactiveValue: Option[Boolean] =
      scala.Option(impl.includeInactive()).map(value => value: Boolean)
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetBlueprintsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetBlueprintsRequest.ReadOnly =
    new Wrapper(impl)
}
