package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetAlarmsRequest(
    alarmName: Option[ResourceName] = None,
    pageToken: Option[String] = None,
    monitoredResourceName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest = {
    import GetAlarmsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
      .builder()
      .optionallyWith(alarmName.map(value => value: java.lang.String))(
        _.alarmName
      )
      .optionallyWith(pageToken.map(value => value: java.lang.String))(
        _.pageToken
      )
      .optionallyWith(
        monitoredResourceName.map(value => value: java.lang.String)
      )(_.monitoredResourceName)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetAlarmsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetAlarmsRequest
      .wrap(buildAwsValue())
}
object GetAlarmsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetAlarmsRequest =
      io.github.vigoo.zioaws.lightsail.model.GetAlarmsRequest(
        alarmNameValue.map(value => value),
        pageTokenValue.map(value => value),
        monitoredResourceNameValue.map(value => value)
      )
    def alarmNameValue: Option[ResourceName]
    def pageTokenValue: Option[String]
    def monitoredResourceNameValue: Option[ResourceName]
    def alarmName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("alarmName", alarmNameValue)
    def pageToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("pageToken", pageTokenValue)
    def monitoredResourceName: ZIO[Any, AwsError, ResourceName] = AwsError
      .unwrapOptionField("monitoredResourceName", monitoredResourceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetAlarmsRequest.ReadOnly {
    override def alarmNameValue: Option[ResourceName] =
      scala.Option(impl.alarmName()).map(value => value: ResourceName)
    override def pageTokenValue: Option[String] =
      scala.Option(impl.pageToken()).map(value => value: String)
    override def monitoredResourceNameValue: Option[ResourceName] = scala
      .Option(impl.monitoredResourceName())
      .map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetAlarmsRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetAlarmsRequest.ReadOnly =
    new Wrapper(impl)
}
