package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class EndpointRequest(
    containerName: String,
    containerPort: Integer,
    healthCheck: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.EndpointRequest = {
    import EndpointRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.EndpointRequest
      .builder()
      .containerName(containerName: java.lang.String)
      .containerPort(containerPort: java.lang.Integer)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.EndpointRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.EndpointRequest.wrap(buildAwsValue())
}
object EndpointRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.EndpointRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.EndpointRequest =
      io.github.vigoo.zioaws.lightsail.model.EndpointRequest(
        containerNameValue,
        containerPortValue,
        healthCheckValue.map(value => value.editable)
      )
    def containerNameValue: String
    def containerPortValue: Integer
    def healthCheckValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ]
    def containerName: ZIO[Any, Nothing, String] =
      ZIO.succeed(containerNameValue)
    def containerPort: ZIO[Any, Nothing, Integer] =
      ZIO.succeed(containerPortValue)
    def healthCheck: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheckValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.EndpointRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.EndpointRequest.ReadOnly {
    override def containerNameValue: String = impl.containerName(): String
    override def containerPortValue: Integer = impl.containerPort(): Integer
    override def healthCheckValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig.ReadOnly
    ] = scala
      .Option(impl.healthCheck())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceHealthCheckConfig
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.EndpointRequest
  ): io.github.vigoo.zioaws.lightsail.model.EndpointRequest.ReadOnly =
    new Wrapper(impl)
}
