package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait DistributionMetricName {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.DistributionMetricName
}
object DistributionMetricName {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.DistributionMetricName
  ): io.github.vigoo.zioaws.lightsail.model.DistributionMetricName =
    value match {
      case software.amazon.awssdk.services.lightsail.model.DistributionMetricName.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.lightsail.model.DistributionMetricName.REQUESTS =>
        val r = Requests
        r
      case software.amazon.awssdk.services.lightsail.model.DistributionMetricName.BYTES_DOWNLOADED =>
        val r = BytesDownloaded
        r
      case software.amazon.awssdk.services.lightsail.model.DistributionMetricName.BYTES_UPLOADED =>
        val r = BytesUploaded
        r
      case software.amazon.awssdk.services.lightsail.model.DistributionMetricName.TOTAL_ERROR_RATE =>
        val r = TotalErrorRate
        r
      case software.amazon.awssdk.services.lightsail.model.DistributionMetricName.HTTP4_XX_ERROR_RATE =>
        val r = Http4xxErrorRate
        r
      case software.amazon.awssdk.services.lightsail.model.DistributionMetricName.HTTP5_XX_ERROR_RATE =>
        val r = Http5xxErrorRate
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.DistributionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DistributionMetricName =
      software.amazon.awssdk.services.lightsail.model.DistributionMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object Requests
      extends io.github.vigoo.zioaws.lightsail.model.DistributionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DistributionMetricName =
      software.amazon.awssdk.services.lightsail.model.DistributionMetricName.REQUESTS
  }
  case object BytesDownloaded
      extends io.github.vigoo.zioaws.lightsail.model.DistributionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DistributionMetricName =
      software.amazon.awssdk.services.lightsail.model.DistributionMetricName.BYTES_DOWNLOADED
  }
  case object BytesUploaded
      extends io.github.vigoo.zioaws.lightsail.model.DistributionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DistributionMetricName =
      software.amazon.awssdk.services.lightsail.model.DistributionMetricName.BYTES_UPLOADED
  }
  case object TotalErrorRate
      extends io.github.vigoo.zioaws.lightsail.model.DistributionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DistributionMetricName =
      software.amazon.awssdk.services.lightsail.model.DistributionMetricName.TOTAL_ERROR_RATE
  }
  case object Http4xxErrorRate
      extends io.github.vigoo.zioaws.lightsail.model.DistributionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DistributionMetricName =
      software.amazon.awssdk.services.lightsail.model.DistributionMetricName.HTTP4_XX_ERROR_RATE
  }
  case object Http5xxErrorRate
      extends io.github.vigoo.zioaws.lightsail.model.DistributionMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DistributionMetricName =
      software.amazon.awssdk.services.lightsail.model.DistributionMetricName.HTTP5_XX_ERROR_RATE
  }
}
