package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DistributionBundle(
    bundleId: Option[String] = None,
    name: Option[String] = None,
    price: Option[Float] = None,
    transferPerMonthInGb: Option[Integer] = None,
    isActive: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DistributionBundle = {
    import DistributionBundle.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DistributionBundle
      .builder()
      .optionallyWith(bundleId.map(value => value: java.lang.String))(
        _.bundleId
      )
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(price.map(value => value: java.lang.Float))(_.price)
      .optionallyWith(
        transferPerMonthInGb.map(value => value: java.lang.Integer)
      )(_.transferPerMonthInGb)
      .optionallyWith(isActive.map(value => value: java.lang.Boolean))(
        _.isActive
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DistributionBundle.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DistributionBundle
      .wrap(buildAwsValue())
}
object DistributionBundle {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DistributionBundle
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DistributionBundle =
      io.github.vigoo.zioaws.lightsail.model.DistributionBundle(
        bundleIdValue.map(value => value),
        nameValue.map(value => value),
        priceValue.map(value => value),
        transferPerMonthInGbValue.map(value => value),
        isActiveValue.map(value => value)
      )
    def bundleIdValue: Option[String]
    def nameValue: Option[String]
    def priceValue: Option[Float]
    def transferPerMonthInGbValue: Option[Integer]
    def isActiveValue: Option[Boolean]
    def bundleId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("bundleId", bundleIdValue)
    def name: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", nameValue)
    def price: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("price", priceValue)
    def transferPerMonthInGb: ZIO[Any, AwsError, Integer] = AwsError
      .unwrapOptionField("transferPerMonthInGb", transferPerMonthInGbValue)
    def isActive: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isActive", isActiveValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DistributionBundle
  ) extends io.github.vigoo.zioaws.lightsail.model.DistributionBundle.ReadOnly {
    override def bundleIdValue: Option[String] =
      scala.Option(impl.bundleId()).map(value => value: String)
    override def nameValue: Option[String] =
      scala.Option(impl.name()).map(value => value: String)
    override def priceValue: Option[Float] =
      scala.Option(impl.price()).map(value => value: Float)
    override def transferPerMonthInGbValue: Option[Integer] =
      scala.Option(impl.transferPerMonthInGb()).map(value => value: Integer)
    override def isActiveValue: Option[Boolean] =
      scala.Option(impl.isActive()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DistributionBundle
  ): io.github.vigoo.zioaws.lightsail.model.DistributionBundle.ReadOnly =
    new Wrapper(impl)
}
