package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait DiskSnapshotState {
  def unwrap: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState
}
object DiskSnapshotState {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.DiskSnapshotState
  ): io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState = value match {
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.PENDING =>
      val r = pending
      r
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.COMPLETED =>
      val r = completed
      r
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.ERROR =>
      val r = error
      r
    case software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.UNKNOWN =>
      val r = unknown
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskSnapshotState =
      software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.UNKNOWN_TO_SDK_VERSION
  }
  case object pending
      extends io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskSnapshotState =
      software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.PENDING
  }
  case object completed
      extends io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskSnapshotState =
      software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.COMPLETED
  }
  case object error
      extends io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskSnapshotState =
      software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.ERROR
  }
  case object unknown
      extends io.github.vigoo.zioaws.lightsail.model.DiskSnapshotState {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.DiskSnapshotState =
      software.amazon.awssdk.services.lightsail.model.DiskSnapshotState.UNKNOWN
  }
}
