package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ResourceName,
  NonEmptyString
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DiskMap(
    originalDiskPath: Option[NonEmptyString] = None,
    newDiskName: Option[ResourceName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DiskMap = {
    import DiskMap.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DiskMap
      .builder()
      .optionallyWith(originalDiskPath.map(value => value: java.lang.String))(
        _.originalDiskPath
      )
      .optionallyWith(newDiskName.map(value => value: java.lang.String))(
        _.newDiskName
      )
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.DiskMap.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DiskMap.wrap(buildAwsValue())
}
object DiskMap {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.lightsail.model.DiskMap] =
    BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DiskMap =
      io.github.vigoo.zioaws.lightsail.model.DiskMap(
        originalDiskPathValue.map(value => value),
        newDiskNameValue.map(value => value)
      )
    def originalDiskPathValue: Option[NonEmptyString]
    def newDiskNameValue: Option[ResourceName]
    def originalDiskPath: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("originalDiskPath", originalDiskPathValue)
    def newDiskName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("newDiskName", newDiskNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DiskMap
  ) extends io.github.vigoo.zioaws.lightsail.model.DiskMap.ReadOnly {
    override def originalDiskPathValue: Option[NonEmptyString] =
      scala.Option(impl.originalDiskPath()).map(value => value: NonEmptyString)
    override def newDiskNameValue: Option[ResourceName] =
      scala.Option(impl.newDiskName()).map(value => value: ResourceName)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DiskMap
  ): io.github.vigoo.zioaws.lightsail.model.DiskMap.ReadOnly = new Wrapper(impl)
}
