package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisableAddOnRequest(
    addOnType: io.github.vigoo.zioaws.lightsail.model.AddOnType,
    resourceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest = {
    import DisableAddOnRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest
      .builder()
      .addOnType(addOnType.unwrap)
      .resourceName(resourceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DisableAddOnRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DisableAddOnRequest
      .wrap(buildAwsValue())
}
object DisableAddOnRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DisableAddOnRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DisableAddOnRequest(addOnTypeValue, resourceNameValue)
    def addOnTypeValue: io.github.vigoo.zioaws.lightsail.model.AddOnType
    def resourceNameValue: ResourceName
    def addOnType
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.AddOnType] =
      ZIO.succeed(addOnTypeValue)
    def resourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DisableAddOnRequest.ReadOnly {
    override def addOnTypeValue
        : io.github.vigoo.zioaws.lightsail.model.AddOnType =
      io.github.vigoo.zioaws.lightsail.model.AddOnType.wrap(impl.addOnType())
    override def resourceNameValue: ResourceName =
      impl.resourceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DisableAddOnRequest
  ): io.github.vigoo.zioaws.lightsail.model.DisableAddOnRequest.ReadOnly =
    new Wrapper(impl)
}
