package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteInstanceRequest(
    instanceName: ResourceName,
    forceDeleteAddOns: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest = {
    import DeleteInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest
      .builder()
      .instanceName(instanceName: java.lang.String)
      .optionallyWith(forceDeleteAddOns.map(value => value: java.lang.Boolean))(
        _.forceDeleteAddOns
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteInstanceRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteInstanceRequest
      .wrap(buildAwsValue())
}
object DeleteInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DeleteInstanceRequest =
      io.github.vigoo.zioaws.lightsail.model.DeleteInstanceRequest(
        instanceNameValue,
        forceDeleteAddOnsValue.map(value => value)
      )
    def instanceNameValue: ResourceName
    def forceDeleteAddOnsValue: Option[Boolean]
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
    def forceDeleteAddOns: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDeleteAddOns", forceDeleteAddOnsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteInstanceRequest.ReadOnly {
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
    override def forceDeleteAddOnsValue: Option[Boolean] =
      scala.Option(impl.forceDeleteAddOns()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteInstanceRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
