package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.DomainName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDomainRequest(domainName: DomainName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest = {
    import DeleteDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteDomainRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteDomainRequest
      .wrap(buildAwsValue())
}
object DeleteDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DeleteDomainRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteDomainRequest(domainNameValue)
    def domainNameValue: DomainName
    def domainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteDomainRequest.ReadOnly {
    override def domainNameValue: DomainName = impl.domainName(): DomainName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteDomainRequest.ReadOnly =
    new Wrapper(impl)
}
