package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.DomainName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDomainEntryRequest(
    domainName: DomainName,
    domainEntry: io.github.vigoo.zioaws.lightsail.model.DomainEntry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest = {
    import DeleteDomainEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .domainEntry(domainEntry.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryRequest
      .wrap(buildAwsValue())
}
object DeleteDomainEntryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteDomainEntryRequest(domainNameValue, domainEntryValue.editable)
    def domainNameValue: DomainName
    def domainEntryValue
        : io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly
    def domainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainNameValue)
    def domainEntry: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly
    ] = ZIO.succeed(domainEntryValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryRequest.ReadOnly {
    override def domainNameValue: DomainName = impl.domainName(): DomainName
    override def domainEntryValue
        : io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly =
      io.github.vigoo.zioaws.lightsail.model.DomainEntry
        .wrap(impl.domainEntry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDomainEntryRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteDomainEntryRequest.ReadOnly =
    new Wrapper(impl)
}
