package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDiskRequest(
    diskName: ResourceName,
    forceDeleteAddOns: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest = {
    import DeleteDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest
      .builder()
      .diskName(diskName: java.lang.String)
      .optionallyWith(forceDeleteAddOns.map(value => value: java.lang.Boolean))(
        _.forceDeleteAddOns
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteDiskRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteDiskRequest
      .wrap(buildAwsValue())
}
object DeleteDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.DeleteDiskRequest =
      io.github.vigoo.zioaws.lightsail.model.DeleteDiskRequest(
        diskNameValue,
        forceDeleteAddOnsValue.map(value => value)
      )
    def diskNameValue: ResourceName
    def forceDeleteAddOnsValue: Option[Boolean]
    def diskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskNameValue)
    def forceDeleteAddOns: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDeleteAddOns", forceDeleteAddOnsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteDiskRequest.ReadOnly {
    override def diskNameValue: ResourceName = impl.diskName(): ResourceName
    override def forceDeleteAddOnsValue: Option[Boolean] =
      scala.Option(impl.forceDeleteAddOns()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteDiskRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteDiskRequest.ReadOnly =
    new Wrapper(impl)
}
