package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteContainerImageRequest(
    serviceName: ContainerServiceName,
    image: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest = {
    import DeleteContainerImageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .image(image: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageRequest
      .wrap(buildAwsValue())
}
object DeleteContainerImageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteContainerImageRequest(serviceNameValue, imageValue)
    def serviceNameValue: ContainerServiceName
    def imageValue: String
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
    def image: ZIO[Any, Nothing, String] = ZIO.succeed(imageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
    override def imageValue: String = impl.image(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteContainerImageRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteContainerImageRequest.ReadOnly =
    new Wrapper(impl)
}
