package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.CertificateName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteCertificateRequest(certificateName: CertificateName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest = {
    import DeleteCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest
      .builder()
      .certificateName(certificateName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteCertificateRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteCertificateRequest
      .wrap(buildAwsValue())
}
object DeleteCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteCertificateRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteCertificateRequest(certificateNameValue)
    def certificateNameValue: CertificateName
    def certificateName: ZIO[Any, Nothing, CertificateName] =
      ZIO.succeed(certificateNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteCertificateRequest.ReadOnly {
    override def certificateNameValue: CertificateName =
      impl.certificateName(): CertificateName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteCertificateRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
