package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  BucketName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteBucketAccessKeyRequest(
    bucketName: BucketName,
    accessKeyId: NonEmptyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest = {
    import DeleteBucketAccessKeyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest
      .builder()
      .bucketName(bucketName: java.lang.String)
      .accessKeyId(accessKeyId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyRequest
      .wrap(buildAwsValue())
}
object DeleteBucketAccessKeyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteBucketAccessKeyRequest(bucketNameValue, accessKeyIdValue)
    def bucketNameValue: BucketName
    def accessKeyIdValue: NonEmptyString
    def bucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketNameValue)
    def accessKeyId: ZIO[Any, Nothing, NonEmptyString] =
      ZIO.succeed(accessKeyIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyRequest.ReadOnly {
    override def bucketNameValue: BucketName = impl.bucketName(): BucketName
    override def accessKeyIdValue: NonEmptyString =
      impl.accessKeyId(): NonEmptyString
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteBucketAccessKeyRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteBucketAccessKeyRequest.ReadOnly =
    new Wrapper(impl)
}
