package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  AutoSnapshotDate,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteAutoSnapshotRequest(
    resourceName: ResourceName,
    date: AutoSnapshotDate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest = {
    import DeleteAutoSnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .date(date: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotRequest
      .wrap(buildAwsValue())
}
object DeleteAutoSnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model
        .DeleteAutoSnapshotRequest(resourceNameValue, dateValue)
    def resourceNameValue: ResourceName
    def dateValue: AutoSnapshotDate
    def resourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceNameValue)
    def date: ZIO[Any, Nothing, AutoSnapshotDate] = ZIO.succeed(dateValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotRequest.ReadOnly {
    override def resourceNameValue: ResourceName =
      impl.resourceName(): ResourceName
    override def dateValue: AutoSnapshotDate = impl.date(): AutoSnapshotDate
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.DeleteAutoSnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.DeleteAutoSnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
