package io.github.vigoo.zioaws.lightsail.model
import java.lang.Integer
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  DomainName,
  Port,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateLoadBalancerRequest(
    loadBalancerName: ResourceName,
    instancePort: Port,
    healthCheckPath: Option[String] = None,
    certificateName: Option[ResourceName] = None,
    certificateDomainName: Option[DomainName] = None,
    certificateAlternativeNames: Option[Iterable[DomainName]] = None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    ipAddressType: Option[
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest = {
    import CreateLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .instancePort(instancePort: Integer)
      .optionallyWith(healthCheckPath.map(value => value: java.lang.String))(
        _.healthCheckPath
      )
      .optionallyWith(certificateName.map(value => value: java.lang.String))(
        _.certificateName
      )
      .optionallyWith(
        certificateDomainName.map(value => value: java.lang.String)
      )(_.certificateDomainName)
      .optionallyWith(
        certificateAlternativeNames.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.certificateAlternativeNames)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(ipAddressType.map(value => value.unwrap))(_.ipAddressType)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerRequest
      .wrap(buildAwsValue())
}
object CreateLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerRequest =
      io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerRequest(
        loadBalancerNameValue,
        instancePortValue,
        healthCheckPathValue.map(value => value),
        certificateNameValue.map(value => value),
        certificateDomainNameValue.map(value => value),
        certificateAlternativeNamesValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        ipAddressTypeValue.map(value => value)
      )
    def loadBalancerNameValue: ResourceName
    def instancePortValue: Port
    def healthCheckPathValue: Option[String]
    def certificateNameValue: Option[ResourceName]
    def certificateDomainNameValue: Option[DomainName]
    def certificateAlternativeNamesValue: Option[List[DomainName]]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType]
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
    def instancePort: ZIO[Any, Nothing, Port] = ZIO.succeed(instancePortValue)
    def healthCheckPath: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("healthCheckPath", healthCheckPathValue)
    def certificateName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("certificateName", certificateNameValue)
    def certificateDomainName: ZIO[Any, AwsError, DomainName] = AwsError
      .unwrapOptionField("certificateDomainName", certificateDomainNameValue)
    def certificateAlternativeNames: ZIO[Any, AwsError, List[DomainName]] =
      AwsError.unwrapOptionField(
        "certificateAlternativeNames",
        certificateAlternativeNamesValue
      )
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def ipAddressType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.IpAddressType
    ] = AwsError.unwrapOptionField("ipAddressType", ipAddressTypeValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
    override def instancePortValue: Port = impl.instancePort(): Port
    override def healthCheckPathValue: Option[String] =
      scala.Option(impl.healthCheckPath()).map(value => value: String)
    override def certificateNameValue: Option[ResourceName] =
      scala.Option(impl.certificateName()).map(value => value: ResourceName)
    override def certificateDomainNameValue: Option[DomainName] =
      scala.Option(impl.certificateDomainName()).map(value => value: DomainName)
    override def certificateAlternativeNamesValue: Option[List[DomainName]] =
      scala
        .Option(impl.certificateAlternativeNames())
        .map(value =>
          value.asScala.map { item =>
            item: DomainName
          }.toList
        )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def ipAddressTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.IpAddressType] = scala
      .Option(impl.ipAddressType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.IpAddressType.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateLoadBalancerRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
