package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Base64
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateKeyPairResponse(
    keyPair: Option[io.github.vigoo.zioaws.lightsail.model.KeyPair] = None,
    publicKeyBase64: Option[Base64] = None,
    privateKeyBase64: Option[Base64] = None,
    operation: Option[io.github.vigoo.zioaws.lightsail.model.Operation] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse = {
    import CreateKeyPairResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse
      .builder()
      .optionallyWith(keyPair.map(value => value.buildAwsValue()))(_.keyPair)
      .optionallyWith(publicKeyBase64.map(value => value: java.lang.String))(
        _.publicKeyBase64
      )
      .optionallyWith(privateKeyBase64.map(value => value: java.lang.String))(
        _.privateKeyBase64
      )
      .optionallyWith(operation.map(value => value.buildAwsValue()))(
        _.operation
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse
      .wrap(buildAwsValue())
}
object CreateKeyPairResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse =
      io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse(
        keyPairValue.map(value => value.editable),
        publicKeyBase64Value.map(value => value),
        privateKeyBase64Value.map(value => value),
        operationValue.map(value => value.editable)
      )
    def keyPairValue
        : Option[io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly]
    def publicKeyBase64Value: Option[Base64]
    def privateKeyBase64Value: Option[Base64]
    def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly]
    def keyPair: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly
    ] = AwsError.unwrapOptionField("keyPair", keyPairValue)
    def publicKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("publicKeyBase64", publicKeyBase64Value)
    def privateKeyBase64: ZIO[Any, AwsError, Base64] =
      AwsError.unwrapOptionField("privateKeyBase64", privateKeyBase64Value)
    def operation: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly
    ] = AwsError.unwrapOptionField("operation", operationValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.ReadOnly {
    override def keyPairValue
        : Option[io.github.vigoo.zioaws.lightsail.model.KeyPair.ReadOnly] =
      scala
        .Option(impl.keyPair())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.KeyPair.wrap(value)
        )
    override def publicKeyBase64Value: Option[Base64] =
      scala.Option(impl.publicKeyBase64()).map(value => value: Base64)
    override def privateKeyBase64Value: Option[Base64] =
      scala.Option(impl.privateKeyBase64()).map(value => value: Base64)
    override def operationValue
        : Option[io.github.vigoo.zioaws.lightsail.model.Operation.ReadOnly] =
      scala
        .Option(impl.operation())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.Operation.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateKeyPairResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateKeyPairResponse.ReadOnly =
    new Wrapper(impl)
}
