package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.DomainName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateDomainEntryRequest(
    domainName: DomainName,
    domainEntry: io.github.vigoo.zioaws.lightsail.model.DomainEntry
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest = {
    import CreateDomainEntryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest
      .builder()
      .domainName(domainName: java.lang.String)
      .domainEntry(domainEntry.buildAwsValue())
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryRequest
      .wrap(buildAwsValue())
}
object CreateDomainEntryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryRequest =
      io.github.vigoo.zioaws.lightsail.model
        .CreateDomainEntryRequest(domainNameValue, domainEntryValue.editable)
    def domainNameValue: DomainName
    def domainEntryValue
        : io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly
    def domainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainNameValue)
    def domainEntry: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly
    ] = ZIO.succeed(domainEntryValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryRequest.ReadOnly {
    override def domainNameValue: DomainName = impl.domainName(): DomainName
    override def domainEntryValue
        : io.github.vigoo.zioaws.lightsail.model.DomainEntry.ReadOnly =
      io.github.vigoo.zioaws.lightsail.model.DomainEntry
        .wrap(impl.domainEntry())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateDomainEntryRequest
  ): io.github.vigoo.zioaws.lightsail.model.CreateDomainEntryRequest.ReadOnly =
    new Wrapper(impl)
}
