package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateContainerServiceResponse(
    containerService: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerService
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse = {
    import CreateContainerServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse
      .builder()
      .optionallyWith(containerService.map(value => value.buildAwsValue()))(
        _.containerService
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse
      .wrap(buildAwsValue())
}
object CreateContainerServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse =
      io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse(
        containerServiceValue.map(value => value.editable)
      )
    def containerServiceValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly
    ]
    def containerService: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly
    ] = AwsError.unwrapOptionField("containerService", containerServiceValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.ReadOnly {
    override def containerServiceValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly
    ] = scala
      .Option(impl.containerService())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerService.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CreateContainerServiceResponse
  ): io.github.vigoo.zioaws.lightsail.model.CreateContainerServiceResponse.ReadOnly =
    new Wrapper(impl)
}
