package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CopySnapshotRequest(
    sourceSnapshotName: Option[ResourceName] = None,
    sourceResourceName: Option[String] = None,
    restoreDate: Option[String] = None,
    useLatestRestorableAutoSnapshot: Option[Boolean] = None,
    targetSnapshotName: ResourceName,
    sourceRegion: io.github.vigoo.zioaws.lightsail.model.RegionName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest = {
    import CopySnapshotRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest
      .builder()
      .optionallyWith(sourceSnapshotName.map(value => value: java.lang.String))(
        _.sourceSnapshotName
      )
      .optionallyWith(sourceResourceName.map(value => value: java.lang.String))(
        _.sourceResourceName
      )
      .optionallyWith(restoreDate.map(value => value: java.lang.String))(
        _.restoreDate
      )
      .optionallyWith(
        useLatestRestorableAutoSnapshot.map(value => value: java.lang.Boolean)
      )(_.useLatestRestorableAutoSnapshot)
      .targetSnapshotName(targetSnapshotName: java.lang.String)
      .sourceRegion(sourceRegion.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CopySnapshotRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CopySnapshotRequest
      .wrap(buildAwsValue())
}
object CopySnapshotRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.CopySnapshotRequest =
      io.github.vigoo.zioaws.lightsail.model.CopySnapshotRequest(
        sourceSnapshotNameValue.map(value => value),
        sourceResourceNameValue.map(value => value),
        restoreDateValue.map(value => value),
        useLatestRestorableAutoSnapshotValue.map(value => value),
        targetSnapshotNameValue,
        sourceRegionValue
      )
    def sourceSnapshotNameValue: Option[ResourceName]
    def sourceResourceNameValue: Option[String]
    def restoreDateValue: Option[String]
    def useLatestRestorableAutoSnapshotValue: Option[Boolean]
    def targetSnapshotNameValue: ResourceName
    def sourceRegionValue: io.github.vigoo.zioaws.lightsail.model.RegionName
    def sourceSnapshotName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("sourceSnapshotName", sourceSnapshotNameValue)
    def sourceResourceName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sourceResourceName", sourceResourceNameValue)
    def restoreDate: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("restoreDate", restoreDateValue)
    def useLatestRestorableAutoSnapshot: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "useLatestRestorableAutoSnapshot",
        useLatestRestorableAutoSnapshotValue
      )
    def targetSnapshotName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(targetSnapshotNameValue)
    def sourceRegion
        : ZIO[Any, Nothing, io.github.vigoo.zioaws.lightsail.model.RegionName] =
      ZIO.succeed(sourceRegionValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CopySnapshotRequest.ReadOnly {
    override def sourceSnapshotNameValue: Option[ResourceName] =
      scala.Option(impl.sourceSnapshotName()).map(value => value: ResourceName)
    override def sourceResourceNameValue: Option[String] =
      scala.Option(impl.sourceResourceName()).map(value => value: String)
    override def restoreDateValue: Option[String] =
      scala.Option(impl.restoreDate()).map(value => value: String)
    override def useLatestRestorableAutoSnapshotValue: Option[Boolean] = scala
      .Option(impl.useLatestRestorableAutoSnapshot())
      .map(value => value: Boolean)
    override def targetSnapshotNameValue: ResourceName =
      impl.targetSnapshotName(): ResourceName
    override def sourceRegionValue
        : io.github.vigoo.zioaws.lightsail.model.RegionName =
      io.github.vigoo.zioaws.lightsail.model.RegionName
        .wrap(impl.sourceRegion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CopySnapshotRequest
  ): io.github.vigoo.zioaws.lightsail.model.CopySnapshotRequest.ReadOnly =
    new Wrapper(impl)
}
