package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerServiceProtocol {
  def unwrap
      : software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol
}
object ContainerServiceProtocol {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol =
    value match {
      case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.HTTP =>
        val r = HTTP
        r
      case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.HTTPS =>
        val r = HTTPS
        r
      case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.TCP =>
        val r = TCP
        r
      case software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.UDP =>
        val r = UDP
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTP
      extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.HTTP
  }
  case object HTTPS
      extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.HTTPS
  }
  case object TCP
      extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.TCP
  }
  case object UDP
      extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceProtocol {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceProtocol.UDP
  }
}
