package io.github.vigoo.zioaws.lightsail.model
import scala.jdk.CollectionConverters.*
sealed trait ContainerServiceMetricName {
  def unwrap: software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName
}
object ContainerServiceMetricName {
  def wrap(
      value: software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName
  ): io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName =
    value match {
      case software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.UNKNOWN_TO_SDK_VERSION =>
        val r = unknownToSdkVersion
        r
      case software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.CPU_UTILIZATION =>
        val r = CPUUtilization
        r
      case software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.MEMORY_UTILIZATION =>
        val r = MemoryUtilization
        r
    }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.UNKNOWN_TO_SDK_VERSION
  }
  case object CPUUtilization
      extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.CPU_UTILIZATION
  }
  case object MemoryUtilization
      extends io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName {
    override def unwrap
        : software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName =
      software.amazon.awssdk.services.lightsail.model.ContainerServiceMetricName.MEMORY_UTILIZATION
  }
}
