package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.ZIO
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  ContainerServiceScale,
  IsoDate,
  NonEmptyString,
  ContainerServiceName
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ContainerService(
    containerServiceName: Option[ContainerServiceName] = None,
    arn: Option[NonEmptyString] = None,
    createdAt: Option[IsoDate] = None,
    location: Option[io.github.vigoo.zioaws.lightsail.model.ResourceLocation] =
      None,
    resourceType: Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] =
      None,
    tags: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Tag]] = None,
    power: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ] = None,
    powerId: Option[String] = None,
    state: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceState
    ] = None,
    stateDetail: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail
    ] = None,
    scale: Option[ContainerServiceScale] = None,
    currentDeployment: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment
    ] = None,
    nextDeployment: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment
    ] = None,
    isDisabled: Option[Boolean] = None,
    principalArn: Option[String] = None,
    privateDomainName: Option[String] = None,
    publicDomainNames: Option[Map[String, Iterable[String]]] = None,
    url: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ContainerService = {
    import ContainerService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ContainerService
      .builder()
      .optionallyWith(
        containerServiceName.map(value => value: java.lang.String)
      )(_.containerServiceName)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(location.map(value => value.buildAwsValue()))(_.location)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(power.map(value => value.unwrap))(_.power)
      .optionallyWith(powerId.map(value => value: java.lang.String))(_.powerId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(stateDetail.map(value => value.buildAwsValue()))(
        _.stateDetail
      )
      .optionallyWith(scale.map(value => value: Integer))(_.scale)
      .optionallyWith(currentDeployment.map(value => value.buildAwsValue()))(
        _.currentDeployment
      )
      .optionallyWith(nextDeployment.map(value => value.buildAwsValue()))(
        _.nextDeployment
      )
      .optionallyWith(isDisabled.map(value => value: java.lang.Boolean))(
        _.isDisabled
      )
      .optionallyWith(principalArn.map(value => value: java.lang.String))(
        _.principalArn
      )
      .optionallyWith(privateDomainName.map(value => value: java.lang.String))(
        _.privateDomainName
      )
      .optionallyWith(
        publicDomainNames.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> value.map { item =>
                item: java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.publicDomainNames)
      .optionallyWith(url.map(value => value: java.lang.String))(_.url)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ContainerService
      .wrap(buildAwsValue())
}
object ContainerService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ContainerService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.ContainerService =
      io.github.vigoo.zioaws.lightsail.model.ContainerService(
        containerServiceNameValue.map(value => value),
        arnValue.map(value => value),
        createdAtValue.map(value => value),
        locationValue.map(value => value.editable),
        resourceTypeValue.map(value => value),
        tagsValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        powerValue.map(value => value),
        powerIdValue.map(value => value),
        stateValue.map(value => value),
        stateDetailValue.map(value => value.editable),
        scaleValue.map(value => value),
        currentDeploymentValue.map(value => value.editable),
        nextDeploymentValue.map(value => value.editable),
        isDisabledValue.map(value => value),
        principalArnValue.map(value => value),
        privateDomainNameValue.map(value => value),
        publicDomainNamesValue.map(value => value),
        urlValue.map(value => value)
      )
    def containerServiceNameValue: Option[ContainerServiceName]
    def arnValue: Option[NonEmptyString]
    def createdAtValue: Option[IsoDate]
    def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ]
    def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType]
    def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]]
    def powerValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ]
    def powerIdValue: Option[String]
    def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ContainerServiceState]
    def stateDetailValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail.ReadOnly
    ]
    def scaleValue: Option[ContainerServiceScale]
    def currentDeploymentValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ]
    def nextDeploymentValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ]
    def isDisabledValue: Option[Boolean]
    def principalArnValue: Option[String]
    def privateDomainNameValue: Option[String]
    def publicDomainNamesValue: Option[Map[String, List[String]]]
    def urlValue: Option[String]
    def containerServiceName: ZIO[Any, AwsError, ContainerServiceName] =
      AwsError.unwrapOptionField(
        "containerServiceName",
        containerServiceNameValue
      )
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def location: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = AwsError.unwrapOptionField("location", locationValue)
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ResourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def tags: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tagsValue)
    def power: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ] = AwsError.unwrapOptionField("power", powerValue)
    def powerId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("powerId", powerIdValue)
    def state: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceState
    ] = AwsError.unwrapOptionField("state", stateValue)
    def stateDetail: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail.ReadOnly
    ] = AwsError.unwrapOptionField("stateDetail", stateDetailValue)
    def scale: ZIO[Any, AwsError, ContainerServiceScale] =
      AwsError.unwrapOptionField("scale", scaleValue)
    def currentDeployment: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("currentDeployment", currentDeploymentValue)
    def nextDeployment: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = AwsError.unwrapOptionField("nextDeployment", nextDeploymentValue)
    def isDisabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("isDisabled", isDisabledValue)
    def principalArn: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("principalArn", principalArnValue)
    def privateDomainName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("privateDomainName", privateDomainNameValue)
    def publicDomainNames: ZIO[Any, AwsError, Map[String, List[String]]] =
      AwsError.unwrapOptionField("publicDomainNames", publicDomainNamesValue)
    def url: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("url", urlValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerService
  ) extends io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly {
    override def containerServiceNameValue: Option[ContainerServiceName] = scala
      .Option(impl.containerServiceName())
      .map(value => value: ContainerServiceName)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def locationValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ResourceLocation.ReadOnly
    ] = scala
      .Option(impl.location())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceLocation.wrap(value)
      )
    override def resourceTypeValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ResourceType] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ResourceType.wrap(value)
      )
    override def tagsValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Tag.ReadOnly]] =
      scala
        .Option(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Tag.wrap(item)
          }.toList
        )
    override def powerValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
    ] = scala
      .Option(impl.power())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServicePowerName
          .wrap(value)
      )
    override def powerIdValue: Option[String] =
      scala.Option(impl.powerId()).map(value => value: String)
    override def stateValue
        : Option[io.github.vigoo.zioaws.lightsail.model.ContainerServiceState] =
      scala
        .Option(impl.state())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.ContainerServiceState
            .wrap(value)
        )
    override def stateDetailValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail.ReadOnly
    ] = scala
      .Option(impl.stateDetail())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceStateDetail
          .wrap(value)
      )
    override def scaleValue: Option[ContainerServiceScale] =
      scala.Option(impl.scale()).map(value => value: ContainerServiceScale)
    override def currentDeploymentValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = scala
      .Option(impl.currentDeployment())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment
          .wrap(value)
      )
    override def nextDeploymentValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment.ReadOnly
    ] = scala
      .Option(impl.nextDeployment())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceDeployment
          .wrap(value)
      )
    override def isDisabledValue: Option[Boolean] =
      scala.Option(impl.isDisabled()).map(value => value: Boolean)
    override def principalArnValue: Option[String] =
      scala.Option(impl.principalArn()).map(value => value: String)
    override def privateDomainNameValue: Option[String] =
      scala.Option(impl.privateDomainName()).map(value => value: String)
    override def publicDomainNamesValue: Option[Map[String, List[String]]] =
      scala
        .Option(impl.publicDomainNames())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              (key: String) -> value.asScala.map { item =>
                item: String
              }.toList
            })
            .toMap
        )
    override def urlValue: Option[String] =
      scala.Option(impl.url()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ContainerService
  ): io.github.vigoo.zioaws.lightsail.model.ContainerService.ReadOnly =
    new Wrapper(impl)
}
