package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CloseInstancePublicPortsRequest(
    portInfo: io.github.vigoo.zioaws.lightsail.model.PortInfo,
    instanceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest = {
    import CloseInstancePublicPortsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest
      .builder()
      .portInfo(portInfo.buildAwsValue())
      .instanceName(instanceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsRequest
      .wrap(buildAwsValue())
}
object CloseInstancePublicPortsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsRequest =
      io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsRequest(
        portInfoValue.editable,
        instanceNameValue
      )
    def portInfoValue: io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly
    def instanceNameValue: ResourceName
    def portInfo: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly
    ] = ZIO.succeed(portInfoValue)
    def instanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(instanceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsRequest.ReadOnly {
    override def portInfoValue
        : io.github.vigoo.zioaws.lightsail.model.PortInfo.ReadOnly =
      io.github.vigoo.zioaws.lightsail.model.PortInfo.wrap(impl.portInfo())
    override def instanceNameValue: ResourceName =
      impl.instanceName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.CloseInstancePublicPortsRequest
  ): io.github.vigoo.zioaws.lightsail.model.CloseInstancePublicPortsRequest.ReadOnly =
    new Wrapper(impl)
}
