package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.NonEmptyString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class BucketState(
    code: Option[NonEmptyString] = None,
    message: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.BucketState = {
    import BucketState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.BucketState
      .builder()
      .optionallyWith(code.map(value => value: java.lang.String))(_.code)
      .optionallyWith(message.map(value => value: java.lang.String))(_.message)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.BucketState.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.BucketState.wrap(buildAwsValue())
}
object BucketState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.BucketState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.BucketState =
      io.github.vigoo.zioaws.lightsail.model.BucketState(
        codeValue.map(value => value),
        messageValue.map(value => value)
      )
    def codeValue: Option[NonEmptyString]
    def messageValue: Option[String]
    def code: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("code", codeValue)
    def message: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("message", messageValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.BucketState
  ) extends io.github.vigoo.zioaws.lightsail.model.BucketState.ReadOnly {
    override def codeValue: Option[NonEmptyString] =
      scala.Option(impl.code()).map(value => value: NonEmptyString)
    override def messageValue: Option[String] =
      scala.Option(impl.message()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.BucketState
  ): io.github.vigoo.zioaws.lightsail.model.BucketState.ReadOnly = new Wrapper(
    impl
  )
}
