package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.IsoDate
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AutoSnapshotDetails(
    date: Option[String] = None,
    createdAt: Option[IsoDate] = None,
    status: Option[io.github.vigoo.zioaws.lightsail.model.AutoSnapshotStatus] =
      None,
    fromAttachedDisks: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.AttachedDisk]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails = {
    import AutoSnapshotDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
      .builder()
      .optionallyWith(date.map(value => value: java.lang.String))(_.date)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        fromAttachedDisks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fromAttachedDisks)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails
      .wrap(buildAwsValue())
}
object AutoSnapshotDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails =
      io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails(
        dateValue.map(value => value),
        createdAtValue.map(value => value),
        statusValue.map(value => value),
        fromAttachedDisksValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def dateValue: Option[String]
    def createdAtValue: Option[IsoDate]
    def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AutoSnapshotStatus]
    def fromAttachedDisksValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AttachedDisk.ReadOnly]
    ]
    def date: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("date", dateValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def status: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AutoSnapshotStatus
    ] = AwsError.unwrapOptionField("status", statusValue)
    def fromAttachedDisks: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.AttachedDisk.ReadOnly
    ]] = AwsError.unwrapOptionField("fromAttachedDisks", fromAttachedDisksValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ) extends io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails.ReadOnly {
    override def dateValue: Option[String] =
      scala.Option(impl.date()).map(value => value: String)
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def statusValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AutoSnapshotStatus] =
      scala
        .Option(impl.status())
        .map(value =>
          io.github.vigoo.zioaws.lightsail.model.AutoSnapshotStatus.wrap(value)
        )
    override def fromAttachedDisksValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.AttachedDisk.ReadOnly]
    ] = scala
      .Option(impl.fromAttachedDisks())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.AttachedDisk.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AutoSnapshotDetails
  ): io.github.vigoo.zioaws.lightsail.model.AutoSnapshotDetails.ReadOnly =
    new Wrapper(impl)
}
