package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AccessRules(
    getObject: Option[io.github.vigoo.zioaws.lightsail.model.AccessType] = None,
    allowPublicOverrides: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.AccessRules = {
    import AccessRules.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.AccessRules
      .builder()
      .optionallyWith(getObject.map(value => value.unwrap))(_.getObject)
      .optionallyWith(
        allowPublicOverrides.map(value => value: java.lang.Boolean)
      )(_.allowPublicOverrides)
      .build()
  }
  def asReadOnly: io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.AccessRules.wrap(buildAwsValue())
}
object AccessRules {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.AccessRules
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.AccessRules =
      io.github.vigoo.zioaws.lightsail.model.AccessRules(
        getObjectValue.map(value => value),
        allowPublicOverridesValue.map(value => value)
      )
    def getObjectValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessType]
    def allowPublicOverridesValue: Option[Boolean]
    def getObject: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.AccessType
    ] = AwsError.unwrapOptionField("getObject", getObjectValue)
    def allowPublicOverrides: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("allowPublicOverrides", allowPublicOverridesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.AccessRules
  ) extends io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly {
    override def getObjectValue
        : Option[io.github.vigoo.zioaws.lightsail.model.AccessType] = scala
      .Option(impl.getObject())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.AccessType.wrap(value)
      )
    override def allowPublicOverridesValue: Option[Boolean] =
      scala.Option(impl.allowPublicOverrides()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.AccessRules
  ): io.github.vigoo.zioaws.lightsail.model.AccessRules.ReadOnly = new Wrapper(
    impl
  )
}
