package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  BucketName,
  ResourceName
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SetResourceAccessForBucketRequest(
    resourceName: ResourceName,
    bucketName: BucketName,
    access: io.github.vigoo.zioaws.lightsail.model.ResourceBucketAccess
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest = {
    import SetResourceAccessForBucketRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest
      .builder()
      .resourceName(resourceName: java.lang.String)
      .bucketName(bucketName: java.lang.String)
      .access(access.unwrap)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketRequest
      .wrap(buildAwsValue())
}
object SetResourceAccessForBucketRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketRequest =
      io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketRequest(
        resourceNameValue,
        bucketNameValue,
        accessValue
      )
    def resourceNameValue: ResourceName
    def bucketNameValue: BucketName
    def accessValue: io.github.vigoo.zioaws.lightsail.model.ResourceBucketAccess
    def resourceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(resourceNameValue)
    def bucketName: ZIO[Any, Nothing, BucketName] = ZIO.succeed(bucketNameValue)
    def access: ZIO[
      Any,
      Nothing,
      io.github.vigoo.zioaws.lightsail.model.ResourceBucketAccess
    ] = ZIO.succeed(accessValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketRequest.ReadOnly {
    override def resourceNameValue: ResourceName =
      impl.resourceName(): ResourceName
    override def bucketNameValue: BucketName = impl.bucketName(): BucketName
    override def accessValue
        : io.github.vigoo.zioaws.lightsail.model.ResourceBucketAccess =
      io.github.vigoo.zioaws.lightsail.model.ResourceBucketAccess
        .wrap(impl.access())
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.SetResourceAccessForBucketRequest
  ): io.github.vigoo.zioaws.lightsail.model.SetResourceAccessForBucketRequest.ReadOnly =
    new Wrapper(impl)
}
