package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class LoadBalancerTlsCertificateRenewalSummary(
    renewalStatus: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
    ] = None,
    domainValidationOptions: Option[Iterable[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary = {
    import LoadBalancerTlsCertificateRenewalSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
      .builder()
      .optionallyWith(renewalStatus.map(value => value.unwrap))(_.renewalStatus)
      .optionallyWith(
        domainValidationOptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainValidationOptions)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
      .wrap(buildAwsValue())
}
object LoadBalancerTlsCertificateRenewalSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary =
      io.github.vigoo.zioaws.lightsail.model
        .LoadBalancerTlsCertificateRenewalSummary(
          renewalStatusValue.map(value => value),
          domainValidationOptionsValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def renewalStatusValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
    ]
    def domainValidationOptionsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly
    ]]
    def renewalStatus: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
    ] = AwsError.unwrapOptionField("renewalStatus", renewalStatusValue)
    def domainValidationOptions: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "domainValidationOptions",
      domainValidationOptionsValue
    )
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
  ) extends io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly {
    override def renewalStatusValue: Option[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
    ] = scala
      .Option(impl.renewalStatus())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalStatus
          .wrap(value)
      )
    override def domainValidationOptionsValue: Option[List[
      io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption.ReadOnly
    ]] = scala
      .Option(impl.domainValidationOptions())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateDomainValidationOption
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.LoadBalancerTlsCertificateRenewalSummary
  ): io.github.vigoo.zioaws.lightsail.model.LoadBalancerTlsCertificateRenewalSummary.ReadOnly =
    new Wrapper(impl)
}
