package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.Integer
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InstanceHardware(
    cpuCount: Option[Integer] = None,
    disks: Option[Iterable[io.github.vigoo.zioaws.lightsail.model.Disk]] = None,
    ramSizeInGb: Option[Float] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.InstanceHardware = {
    import InstanceHardware.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.InstanceHardware
      .builder()
      .optionallyWith(cpuCount.map(value => value: java.lang.Integer))(
        _.cpuCount
      )
      .optionallyWith(
        disks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.disks)
      .optionallyWith(ramSizeInGb.map(value => value: java.lang.Float))(
        _.ramSizeInGb
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.InstanceHardware.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.InstanceHardware
      .wrap(buildAwsValue())
}
object InstanceHardware {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.InstanceHardware
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.InstanceHardware =
      io.github.vigoo.zioaws.lightsail.model.InstanceHardware(
        cpuCountValue.map(value => value),
        disksValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        ramSizeInGbValue.map(value => value)
      )
    def cpuCountValue: Option[Integer]
    def disksValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly]]
    def ramSizeInGbValue: Option[Float]
    def cpuCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("cpuCount", cpuCountValue)
    def disks: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly
    ]] = AwsError.unwrapOptionField("disks", disksValue)
    def ramSizeInGb: ZIO[Any, AwsError, Float] =
      AwsError.unwrapOptionField("ramSizeInGb", ramSizeInGbValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceHardware
  ) extends io.github.vigoo.zioaws.lightsail.model.InstanceHardware.ReadOnly {
    override def cpuCountValue: Option[Integer] =
      scala.Option(impl.cpuCount()).map(value => value: Integer)
    override def disksValue
        : Option[List[io.github.vigoo.zioaws.lightsail.model.Disk.ReadOnly]] =
      scala
        .Option(impl.disks())
        .map(value =>
          value.asScala.map { item =>
            io.github.vigoo.zioaws.lightsail.model.Disk.wrap(item)
          }.toList
        )
    override def ramSizeInGbValue: Option[Float] =
      scala.Option(impl.ramSizeInGb()).map(value => value: Float)
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.InstanceHardware
  ): io.github.vigoo.zioaws.lightsail.model.InstanceHardware.ReadOnly =
    new Wrapper(impl)
}
