package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLoadBalancerRequest(loadBalancerName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest = {
    import GetLoadBalancerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest
      .builder()
      .loadBalancerName(loadBalancerName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerRequest
      .wrap(buildAwsValue())
}
object GetLoadBalancerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetLoadBalancerRequest(loadBalancerNameValue)
    def loadBalancerNameValue: ResourceName
    def loadBalancerName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(loadBalancerNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerRequest.ReadOnly {
    override def loadBalancerNameValue: ResourceName =
      impl.loadBalancerName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetLoadBalancerRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetLoadBalancerRequest.ReadOnly =
    new Wrapper(impl)
}
