package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ResourceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDiskRequest(diskName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetDiskRequest = {
    import GetDiskRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetDiskRequest
      .builder()
      .diskName(diskName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetDiskRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetDiskRequest.wrap(buildAwsValue())
}
object GetDiskRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetDiskRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.lightsail.model.GetDiskRequest =
      io.github.vigoo.zioaws.lightsail.model.GetDiskRequest(diskNameValue)
    def diskNameValue: ResourceName
    def diskName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(diskNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetDiskRequest.ReadOnly {
    override def diskNameValue: ResourceName = impl.diskName(): ResourceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetDiskRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetDiskRequest.ReadOnly =
    new Wrapper(impl)
}
