package io.github.vigoo.zioaws.lightsail.model
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetContainerServiceMetricDataResponse(
    metricName: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName
    ] = None,
    metricData: Option[
      Iterable[io.github.vigoo.zioaws.lightsail.model.MetricDatapoint]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse = {
    import GetContainerServiceMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse
      .builder()
      .optionallyWith(metricName.map(value => value.unwrap))(_.metricName)
      .optionallyWith(
        metricData.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricData)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse
      .wrap(buildAwsValue())
}
object GetContainerServiceMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse =
      io.github.vigoo.zioaws.lightsail.model
        .GetContainerServiceMetricDataResponse(
          metricNameValue.map(value => value),
          metricDataValue.map(value =>
            value.map { item =>
              item.editable
            }
          )
        )
    def metricNameValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName
    ]
    def metricDataValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly]
    ]
    def metricName: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName
    ] = AwsError.unwrapOptionField("metricName", metricNameValue)
    def metricData: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly
    ]] = AwsError.unwrapOptionField("metricData", metricDataValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly {
    override def metricNameValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName
    ] = scala
      .Option(impl.metricName())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ContainerServiceMetricName
          .wrap(value)
      )
    override def metricDataValue: Option[
      List[io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.ReadOnly]
    ] = scala
      .Option(impl.metricData())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.lightsail.model.MetricDatapoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerServiceMetricDataResponse
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerServiceMetricDataResponse.ReadOnly =
    new Wrapper(impl)
}
