package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.ContainerServiceName
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetContainerImagesRequest(serviceName: ContainerServiceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest = {
    import GetContainerImagesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest
      .builder()
      .serviceName(serviceName: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.GetContainerImagesRequest.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.GetContainerImagesRequest
      .wrap(buildAwsValue())
}
object GetContainerImagesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.GetContainerImagesRequest =
      io.github.vigoo.zioaws.lightsail.model
        .GetContainerImagesRequest(serviceNameValue)
    def serviceNameValue: ContainerServiceName
    def serviceName: ZIO[Any, Nothing, ContainerServiceName] =
      ZIO.succeed(serviceNameValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest
  ) extends io.github.vigoo.zioaws.lightsail.model.GetContainerImagesRequest.ReadOnly {
    override def serviceNameValue: ContainerServiceName =
      impl.serviceName(): ContainerServiceName
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.GetContainerImagesRequest
  ): io.github.vigoo.zioaws.lightsail.model.GetContainerImagesRequest.ReadOnly =
    new Wrapper(impl)
}
