package io.github.vigoo.zioaws.lightsail.model
import io.github.vigoo.zioaws.lightsail.model.primitives.{
  NonEmptyString,
  IsoDate
}
import zio.ZIO
import java.time.Instant
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ExportSnapshotRecordSourceInfo(
    resourceType: Option[
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceType
    ] = None,
    createdAt: Option[IsoDate] = None,
    name: Option[NonEmptyString] = None,
    arn: Option[NonEmptyString] = None,
    fromResourceName: Option[NonEmptyString] = None,
    fromResourceArn: Option[NonEmptyString] = None,
    instanceSnapshotInfo: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo
    ] = None,
    diskSnapshotInfo: Option[
      io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo = {
    import ExportSnapshotRecordSourceInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
      .builder()
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(createdAt.map(value => value: Instant))(_.createdAt)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(arn.map(value => value: java.lang.String))(_.arn)
      .optionallyWith(fromResourceName.map(value => value: java.lang.String))(
        _.fromResourceName
      )
      .optionallyWith(fromResourceArn.map(value => value: java.lang.String))(
        _.fromResourceArn
      )
      .optionallyWith(instanceSnapshotInfo.map(value => value.buildAwsValue()))(
        _.instanceSnapshotInfo
      )
      .optionallyWith(diskSnapshotInfo.map(value => value.buildAwsValue()))(
        _.diskSnapshotInfo
      )
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly =
    io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo
      .wrap(buildAwsValue())
}
object ExportSnapshotRecordSourceInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo =
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo(
        resourceTypeValue.map(value => value),
        createdAtValue.map(value => value),
        nameValue.map(value => value),
        arnValue.map(value => value),
        fromResourceNameValue.map(value => value),
        fromResourceArnValue.map(value => value),
        instanceSnapshotInfoValue.map(value => value.editable),
        diskSnapshotInfoValue.map(value => value.editable)
      )
    def resourceTypeValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceType
    ]
    def createdAtValue: Option[IsoDate]
    def nameValue: Option[NonEmptyString]
    def arnValue: Option[NonEmptyString]
    def fromResourceNameValue: Option[NonEmptyString]
    def fromResourceArnValue: Option[NonEmptyString]
    def instanceSnapshotInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo.ReadOnly
    ]
    def diskSnapshotInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo.ReadOnly
    ]
    def resourceType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceType
    ] = AwsError.unwrapOptionField("resourceType", resourceTypeValue)
    def createdAt: ZIO[Any, AwsError, IsoDate] =
      AwsError.unwrapOptionField("createdAt", createdAtValue)
    def name: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", nameValue)
    def arn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("arn", arnValue)
    def fromResourceName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromResourceName", fromResourceNameValue)
    def fromResourceArn: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("fromResourceArn", fromResourceArnValue)
    def instanceSnapshotInfo: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "instanceSnapshotInfo",
      instanceSnapshotInfoValue
    )
    def diskSnapshotInfo: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo.ReadOnly
    ] = AwsError.unwrapOptionField("diskSnapshotInfo", diskSnapshotInfoValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ) extends io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly {
    override def resourceTypeValue: Option[
      io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceType
    ] = scala
      .Option(impl.resourceType())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceType
          .wrap(value)
      )
    override def createdAtValue: Option[IsoDate] =
      scala.Option(impl.createdAt()).map(value => value: IsoDate)
    override def nameValue: Option[NonEmptyString] =
      scala.Option(impl.name()).map(value => value: NonEmptyString)
    override def arnValue: Option[NonEmptyString] =
      scala.Option(impl.arn()).map(value => value: NonEmptyString)
    override def fromResourceNameValue: Option[NonEmptyString] =
      scala.Option(impl.fromResourceName()).map(value => value: NonEmptyString)
    override def fromResourceArnValue: Option[NonEmptyString] =
      scala.Option(impl.fromResourceArn()).map(value => value: NonEmptyString)
    override def instanceSnapshotInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo.ReadOnly
    ] = scala
      .Option(impl.instanceSnapshotInfo())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.InstanceSnapshotInfo.wrap(value)
      )
    override def diskSnapshotInfoValue: Option[
      io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo.ReadOnly
    ] = scala
      .Option(impl.diskSnapshotInfo())
      .map(value =>
        io.github.vigoo.zioaws.lightsail.model.DiskSnapshotInfo.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.lightsail.model.ExportSnapshotRecordSourceInfo
  ): io.github.vigoo.zioaws.lightsail.model.ExportSnapshotRecordSourceInfo.ReadOnly =
    new Wrapper(impl)
}
